<p data-nodeid="1157" class="">首先解答一下上一课时的问题。磁盘的速度这么慢，为什么 Kafka 操作磁盘，吞吐量还能那么高？</p>
<p data-nodeid="1158">这是因为，磁盘之所以慢，主要就是慢在寻道的操作上面。Kafka 官方测试表明，这个寻道时间长达 10ms。磁盘的顺序写和随机写的速度比，可以达到 6 千倍，Kafka 就是采用的顺序写的方式。</p>
<p data-nodeid="1159">经过上一课时我们了解到，想要进行深入排查，需要收集较详细的性能数据，包括操作系统性能数据、JVM 的性能数据、应用的性能数据等。</p>
<p data-nodeid="1160">那么，我们应该如何获取这些数据呢？本课时我将介绍一系列常用的性能测试工具。</p>
<h3 data-nodeid="1161">nmon —— 获取系统性能数据</h3>
<p data-nodeid="1162">除了在上一课时中介绍的 top、free 等命令，还有一些将资源整合在一起的监控工具，</p>
<p data-nodeid="1163">nmon 便是一个老牌的 Linux 性能监控工具，它不仅有漂亮的监控界面（如下图所示），还能产出细致的监控报表。</p>
<p data-nodeid="1164"><img src="https://s0.lgstatic.com/i/image/M00/36/9A/CgqCHl8X2gWANM2wAAkEF7IjoMg031.png" alt="Drawing 0.png" data-nodeid="1268"><br>
nmon 监控界面</p>
<p data-nodeid="1165">我在对应用做性能评估时，通常会加上 nmon 的报告，这会让测试结果更加有说服力。你在平时工作中也可如此尝试。</p>
<p data-nodeid="1166">上一课时介绍的一些操作系统性能指标，都可从 nmon 中获取。它的监控范围很广，包括 CPU、内存、网络、磁盘、文件系统、NFS、系统资源等信息。</p>
<p data-nodeid="1167">nmon 在 sourceforge 发布，我已经下载下来并上传到了仓库中。比如我的是 CentOS 7 系统，选择对应的版本即可执行。</p>
<pre class="lang-java" data-nodeid="1168"><code data-language="java">./nmon_x86_64_centos7
</code></pre>
<p data-nodeid="1169">按 C 键可加入 CPU 面板；按 M 键可加入内存面板；按 N 键可加入网络；按 D 键可加入磁盘等。</p>
<p data-nodeid="1170">通过下面的命令，表示每 5 秒采集一次数据，共采集 12 次，它会把这一段时间之内的数据记录下来。比如本次生成了 localhost_200623_1633.nmon 这个文件，我们把它从服务器上下载下来。</p>
<pre class="lang-java" data-nodeid="1171"><code data-language="java">./nmon_x86_64_centos7 &nbsp;-f -s <span class="hljs-number">5</span> -c <span class="hljs-number">12</span> -m &nbsp;-m .
</code></pre>
<p data-nodeid="1172"><strong data-nodeid="1283">注意：执行命令之后，可以通过 ps 命令找到这个进程。</strong></p>
<pre class="lang-java" data-nodeid="1173"><code data-language="java">[root@localhost nmon16m_helpsystems]# ps -ef| grep nmon
root &nbsp; &nbsp; &nbsp;2228 &nbsp; &nbsp; 1 &nbsp;0 16:33 pts/0 &nbsp; &nbsp;00:00:00 ./nmon_x86_64_centos7 -f -s 5 -c 12 -m .
</code></pre>
<p data-nodeid="1174">使用 nmonchart 工具（见仓库），即可生成 html 文件。下面是生成文件的截图。</p>
<p data-nodeid="1175"><img src="https://s0.lgstatic.com/i/image/M00/36/8F/Ciqc1F8X2m6ABh9lAAqiFOnIMT0061.png" alt="Drawing 1.png" data-nodeid="1287"><br>
nmonchart 报表</p>
<h3 data-nodeid="1176">jvisualvm —— 获取 JVM 性能数据</h3>
<p data-nodeid="1177">jvisualvm 原是随着 JDK 发布的一个工具，Java 9 之后开始单独发布。通过它，可以了解应用在运行中的内部情况。我们可以连接本地或者远程的服务器，监控大量的性能数据。</p>
<p data-nodeid="1178">通过插件功能，jvisualvm 能获得更强大的扩展。如下图所示，建议把所有的插件下载下来进行体验。</p>
<p data-nodeid="1179"><img src="https://s0.lgstatic.com/i/image/M00/36/9C/CgqCHl8X3PeAPufLAAPBFcBR8qY801.png" alt="Drawing 2.png" data-nodeid="1295"><br>
jvisualvm 插件安装</p>
<p data-nodeid="1180">要想监控远程的应用，还需要在被监控的 App 上加入 jmx 参数。</p>
<pre class="lang-java" data-nodeid="1181"><code data-language="java">-Dcom.sun.management.jmxremote.port=<span class="hljs-number">14000</span>
-Dcom.sun.management.jmxremote.authenticate=<span class="hljs-keyword">false</span> 
-Dcom.sun.management.jmxremote.ssl=<span class="hljs-keyword">false</span>
</code></pre>
<p data-nodeid="1182">上述配置的意义是开启 JMX 连接端口 14000，同时配置不需要 SSL 安全认证方式连接。</p>
<p data-nodeid="1183">对于性能优化来说，我们主要用到它的采样器。注意，由于抽样分析过程对程序运行性能有较大的影响，一般我们只在测试环境中使用此功能。</p>
<p data-nodeid="1184"><img src="https://s0.lgstatic.com/i/image/M00/36/9C/CgqCHl8X3QOANLEGAAaKW6xLOSg775.png" alt="Drawing 3.png" data-nodeid="1303"><br>
jvisualvm CPU 性能采样图</p>
<p data-nodeid="1185">对于一个 Java 应用来说，除了要关注它的 CPU 指标，垃圾回收方面也是不容忽视的性能点，我们主要关注以下三点。</p>
<ul data-nodeid="1186">
<li data-nodeid="1187">
<p data-nodeid="1188"><strong data-nodeid="1311">CPU 分析</strong>：统计方法的执行次数和执行耗时，这些数据可用于分析哪个方法执行时间过长，成为热点等。</p>
</li>
<li data-nodeid="1189">
<p data-nodeid="1190"><strong data-nodeid="1316">内存分析</strong>：可以通过内存监视和内存快照等方式进行分析，进而检测内存泄漏问题，优化内存使用情况。</p>
</li>
<li data-nodeid="1191">
<p data-nodeid="1192"><strong data-nodeid="1321">线程分析</strong>：可以查看线程的状态变化，以及一些死锁情况。</p>
</li>
</ul>
<h3 data-nodeid="1193">JMC —— 获取 Java 应用详细性能数据</h3>
<p data-nodeid="1194">对于我们常用的 HotSpot 来说，有更强大的工具，那就是 JMC。 JMC 集成了一个非常好用的功能：JFR（Java Flight Recorder）。</p>
<p data-nodeid="1195">Flight Recorder 源自飞机的黑盒子，是用来录制信息然后事后分析的。在 Java11 中，它可以通过 jcmd 命令进行录制，主要包括 configure、check、start、dump、stop 这五个命令，其执行顺序为，start — dump — stop，例如：</p>
<pre class="lang-js" data-nodeid="3765"><code data-language="js">jcmd &lt;pid&gt; JFR.start
jcmd &lt;pid&gt; JFR.dump filename=recording.jfr
jcmd &lt;pid&gt; JFR.stop
</code></pre>


<p data-nodeid="1197">JFR 功能是建在 JVM 内部的，不需要额外依赖，可以直接使用，它能够监测大量数据。比如，我们提到的锁竞争、延迟、阻塞等；甚至在 JVM 内部，比如 SafePoint、JIT 编译等，也能去分析。</p>
<p data-nodeid="1198"><strong data-nodeid="1330">JMC 集成了 JFR 的功能</strong>，下面介绍一下 JMC 的使用。</p>
<h4 data-nodeid="1199">1.录制</h4>
<p data-nodeid="1200">下图是录制了一个 Tomcat 一分钟之后的结果，从左边的菜单栏即可进入相应的性能界面。</p>
<p data-nodeid="1201"><img src="https://s0.lgstatic.com/i/image/M00/36/9C/CgqCHl8X3SyAbYa7AAfd6jZo6t4915.png" alt="Drawing 4.png" data-nodeid="1335"><br>
JMC 录制结果主界面</p>
<p data-nodeid="2606" class="">通过录制数据，可以清晰了解到某一分钟内，操作系统资源，以及 JVM 内部的性能数据情况。</p>

<h4 data-nodeid="1203">2.线程</h4>
<p data-nodeid="1204">选择相应的线程，即可了解线程的执行情况，比如 Wait、Idle 、Block 等状态和时序。</p>
<p data-nodeid="1205">以 C2 编译器线程为例，可以看到详细的热点类，以及方法内联后的代码大小。如下图所示，C2 此时正在疯狂运转。</p>
<p data-nodeid="1206"><img src="https://s0.lgstatic.com/i/image/M00/36/91/Ciqc1F8X3TWASVq0AAY9V2QKEX8030.png" alt="Drawing 5.png" data-nodeid="1344"><br>
JMC 录制结果 线程界面</p>
<h4 data-nodeid="1207">3.内存</h4>
<p data-nodeid="1208">通过内存界面，可以看到每个时间段内内存的申请情况。在排查内存溢出、内存泄漏等情况时，这个功能非常有用。</p>
<p data-nodeid="1209"><img src="https://s0.lgstatic.com/i/image/M00/36/91/Ciqc1F8X3T6AesX5AAcyVYacyeQ529.png" alt="Drawing 6.png" data-nodeid="1351"><br>
JMC 录制结果 内存界面</p>
<h4 data-nodeid="1210">4.锁</h4>
<p data-nodeid="1211">一些竞争非常严重的锁信息，以及一些死锁信息，都可以在锁信息界面中找到。</p>
<p data-nodeid="1212">可以看到，一些锁的具体 ID，以及关联的线程信息，都可以进行联动分析。</p>
<p data-nodeid="1213"><img src="https://s0.lgstatic.com/i/image/M00/36/9D/CgqCHl8X3UeAJ5L_AAQ7-kTs7YM289.png" alt="Drawing 7.png" data-nodeid="1359"><br>
JMC 录制结果 锁信息界面</p>
<h4 data-nodeid="1214">5.文件和 Socket</h4>
<p data-nodeid="1215">文件和 Socket 界面能够监控对 I/O 的读写，界面一目了然。如果你的应用 I/O 操作比较繁重，比如日志打印比较多、网络读写频繁，就可以在这里监控到相应的信息，并能够和执行栈关联起来。</p>
<p data-nodeid="1216"><img src="https://s0.lgstatic.com/i/image/M00/36/91/Ciqc1F8X3VGABH4xAAfkaSBZDio750.png" alt="Drawing 8.png" data-nodeid="1366"><br>
JMC 录制结果 文件和 Socket 界面</p>
<h4 data-nodeid="1217">6.方法调用</h4>
<p data-nodeid="1218">这个和 jvisualvm 的功能类似，展示的是方法调用信息和排行。从这里可以看到一些高耗时方法和热点方法。</p>
<p data-nodeid="1219"><img src="https://s0.lgstatic.com/i/image/M00/36/9D/CgqCHl8X3WOAYQSCAAVmKbHpuBQ717.png" alt="Drawing 9.png" data-nodeid="1373"><br>
JMC 录制结果 方法调用</p>
<h4 data-nodeid="1220">7.垃圾回收</h4>
<p data-nodeid="1221">如果垃圾回收过于频繁，就会影响应用的性能。JFR 对垃圾回收进行了详细的记录，比如什么时候发生了垃圾回收，用的什么垃圾回收器，每次垃圾回收的耗时，甚至是什么原因引起的等问题，都可以在这里看到。</p>
<p data-nodeid="1222"><img src="https://s0.lgstatic.com/i/image/M00/36/92/Ciqc1F8X3X6ACtlVAAgwHnO3oHQ281.png" alt="Drawing 10.png" data-nodeid="1380"><br>
JMC 录制结果 垃圾回收</p>
<h4 data-nodeid="1223">8.JIT</h4>
<p data-nodeid="1224">JIT 编译后的代码，执行速度会特别快，但它需要一个编译过程。编译界面显示了详细的 JIT 编译过程信息，包括生成后的 CodeCache 大小、方法内联信息等。</p>
<p data-nodeid="1225"><img src="https://s0.lgstatic.com/i/image/M00/36/9D/CgqCHl8X3Y2AWi8dAAZ8RGTPyoA991.png" alt="Drawing 11.png" data-nodeid="1387"><br>
JMC 录制结果 JIT 信息</p>
<h4 data-nodeid="1226">9.TLAB</h4>
<p data-nodeid="1227">JVM 默认给每个线程开辟一个 buffer 区域，用来加速对象分配，这就是 TLAB（Thread Local Allocation Buffer）的概念。这个 buffer，就放在 Eden 区。</p>
<p data-nodeid="1228">原理和 Java 语言中的 ThreadLocal 类似，能够避免对公共区的操作，可以减少一些锁竞争。如下图所示的界面，详细地显示了这个分配过程。</p>
<p data-nodeid="1229"><img src="https://s0.lgstatic.com/i/image/M00/36/9D/CgqCHl8X3baAW4VFAAaz04YR1w4277.png" alt="Drawing 12.png" data-nodeid="1395"><br>
JMC 录制结果 TLAB 信息</p>
<p data-nodeid="1230">在后面的课时中，我们会有多个使用此工具的分析案例。</p>
<h3 data-nodeid="1231">Arthas —— 获取单个请求的调用链耗时</h3>
<p data-nodeid="1232">Arthas 是一个 Java 诊断工具，可以排查内存溢出、CPU 飙升、负载高等内容，可以说是一个 jstack、jmap 等命令的大集合。</p>
<p data-nodeid="1233"><img src="https://s0.lgstatic.com/i/image/M00/36/9D/CgqCHl8X3eSAP67rAANG-JDjv2E614.png" alt="Drawing 13.png" data-nodeid="1403"><br>
Arthas 启动界面</p>
<p data-nodeid="1234">Arthas 支持很多命令，我们以 trace 命令为例。</p>
<p data-nodeid="1235">有时候，我们统计到某个接口的耗时非常高，但又无法找到具体原因时，就可以使用这个 trace 命令。该命令会从方法执行开始记录整个链路上的执行情况，然后统计每个节点的性能开销，最终以树状打印，很多性能问题一眼就能看出来。</p>
<p data-nodeid="1236">下面就是一个执行结果示例。</p>
<pre class="lang-java" data-nodeid="1237"><code data-language="java">$ trace demo.MathGame run
Press Q or Ctrl+C to abort.
Affect(class-cnt:1 , method-cnt:1) cost in 28 ms.
`---ts=2019-12-04 00:45:08;thread_name=main;id=1;is_daemon=false;priority=5;TCCL=sun.misc.Launcher$AppClassLoader@3d4eac69
 &nbsp; &nbsp;`---[0.617465ms] demo.MathGame:run()
 &nbsp; &nbsp; &nbsp; &nbsp;`---[0.078946ms] demo.MathGame:primeFactors() #24 [throws Exception]

`---ts=2019-12-04 00:45:09;thread_name=main;id=1;is_daemon=false;priority=5;TCCL=sun.misc.Launcher$AppClassLoader@3d4eac69
 &nbsp; &nbsp;`---[1.276874ms] demo.MathGame:run()
 &nbsp; &nbsp; &nbsp; &nbsp;`---[0.03752ms] demo.MathGame:primeFactors() #24 [throws Exception]
</code></pre>
<p data-nodeid="1238">我们在后面的课时中，也会有实例来演示如何找到问题发生的具体原因。</p>
<h3 data-nodeid="1239">wrk —— 获取 Web 接口的性能数据</h3>
<p data-nodeid="1240"><a href="https://github.com/wg/wrk" data-nodeid="1413">wrk（点击进入 GitHub 网站查看）</a>是一款 HTTP 压测工具，和 ab 命令类似，它也是一个命令行工具。</p>
<p data-nodeid="1241">我们先来看一下它的执行结果。</p>
<pre class="lang-java" data-nodeid="1242"><code data-language="java">Running <span class="hljs-number">30</span>s test @ http:<span class="hljs-comment">//127.0.0.1:8080/index.html</span>
 &nbsp;<span class="hljs-number">12</span> threads and <span class="hljs-number">400</span> connections
  Thread Stats &nbsp; Avg &nbsp; &nbsp;  Stdev &nbsp; &nbsp; Max &nbsp; +/- Stdev
 &nbsp;  Latency &nbsp; <span class="hljs-number">635.91</span>us &nbsp; &nbsp;<span class="hljs-number">0.89</span>ms &nbsp;<span class="hljs-number">12.92</span>ms &nbsp; <span class="hljs-number">93.69</span>%
 &nbsp;  Req/Sec &nbsp; &nbsp;<span class="hljs-number">56.20</span>k &nbsp; &nbsp; <span class="hljs-number">8.07</span>k &nbsp; <span class="hljs-number">62.00</span>k &nbsp; &nbsp;<span class="hljs-number">86.54</span>%
 &nbsp;<span class="hljs-number">22464657</span> requests in <span class="hljs-number">30.00</span>s, <span class="hljs-number">17.76</span>GB read
Requests/sec: <span class="hljs-number">748868.53</span>
Transfer/sec: &nbsp; &nbsp;<span class="hljs-number">606.33</span>MB
</code></pre>
<p data-nodeid="2026" class="">可以看到，wrk 统计了常见的性能指标，对 Web 服务性能测试非常有用。同时，wrk 支持 Lua 脚本，用来控制 setup、init、delay、request、response 等函数，可以更好地模拟用户请求。</p>


<h3 data-nodeid="1244">小结</h3>
<p data-nodeid="1245">为了获取更多性能数据，我们在本课时介绍了以下 5 款工具。</p>
<ul data-nodeid="1246">
<li data-nodeid="1247">
<p data-nodeid="1248"><strong data-nodeid="1423">nmon</strong> 获取系统性能数据；</p>
</li>
<li data-nodeid="1249">
<p data-nodeid="1250"><strong data-nodeid="1428">jvisualvm</strong> 获取 JVM 性能数据；</p>
</li>
<li data-nodeid="1251">
<p data-nodeid="1252"><strong data-nodeid="1433">jmc</strong> 获取 Java 应用详细性能数据；</p>
</li>
<li data-nodeid="1253">
<p data-nodeid="1254"><strong data-nodeid="1438">arthas</strong> 获取单个请求的调用链耗时；</p>
</li>
<li data-nodeid="1255">
<p data-nodeid="1256"><strong data-nodeid="1443">wrk</strong> 获取 Web 接口的性能数据。</p>
</li>
</ul>
<p data-nodeid="1257">可以看出，这些工具有偏低层的、有偏应用的、有偏统计的、有偏细节的，在定位性能问题时，你需要灵活地使用这些工具，既从全貌上掌握应用的属性，也从细节上找到性能的瓶颈，对应用性能进行全方位的掌控。</p>
<p data-nodeid="1258" class="">这些工具能够很好地帮助我们找到系统的瓶颈点，那么对代码进行优化时，如何分析优化效果呢？又如何对代码片段进行快速、专业的测试呢？下一课时，我将介绍“基准测试 JMH”，来解答以上问题。</p>

---

### 精选评论

##### *瑞：
> 请问有什么方式检查open file 的数量和那里进程导致过高的方法吗？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 一般es等服务，都要求通过MAX_OPEN_FILES等设置文件句柄数，可以根据lsof的输出进行分组统计。

"lsof -n |awk '{print $2}'|sort|uniq -c |sort -nr|"

##### **玮：
> 请问可以获取老师的笔记、课件嘛？怎么获取呢？

 ###### &nbsp;&nbsp;&nbsp; 编辑回复：
> &nbsp;&nbsp;&nbsp; 关注拉勾教育公众号 咨询小助手获取课件

##### **瑜：
> 这些可视化工具在服务器上应该怎么使用呢

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 一般在服务器上使用图形化工具的不多，要真使用的话，还需要开启JMX端口。性能优化不仅仅是面对线上环境的，像很多公司已经具备了全链路压测的功能，在开发测试或者预发布环境，都可以进行性能优化。在我们介绍的工具中，nmon和arthas都是命令行的，更多工具参见03课时。

##### **林：
> 请问开启JMX的三行配置是加在哪里呢？项目的启动参数吗？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; jmx参数都是加在java命令后面的

##### **（yun）：
> 吊吊吊

